--
-- CultivatorFieldCreator
--
-- Author: Wopster
-- Description: allows field creation with cultivators.
-- Icon:
-- Name: cultivatorFieldCreator
-- Hide: no
--
-- Copyright (c) Wopster, 2024

---@type string directory of the mod.
local modDirectory = g_currentModDirectory or ""
---@type string name of the mod.
local modName = g_currentModName or "unknown"

source(modDirectory .. "src/LimitToFieldEvent.lua")

---Add mod specs to game specs.
local function initSpecialization(manager)
    if manager.typeName == "vehicle" then
        for typeName, typeEntry in pairs(g_vehicleTypeManager:getTypes()) do
            if SpecializationUtil.hasSpecialization(Cultivator, typeEntry.specializations) and not SpecializationUtil.hasSpecialization(Plow, typeEntry.specializations) then
                g_vehicleTypeManager:addSpecialization(typeName, modName .. ".cultivatorFieldCreator")
            end
        end
    end
end

---Init the mod.
local function init()
    TypeManager.validateTypes = Utils.prependedFunction(TypeManager.validateTypes, initSpecialization)
end

init()
